<?php

    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    class FileScaricabile {
        private $db;
        private $id;
        private $nome; 	 		
	private $password;	 		
	private $percorso;	 		
	private $descrizione; 	 		
	private $immagine;
	private $categoria;
	private $posizione; 			
	private $numeroDownload; 	 			
	private $dataCreazione; 
        
        public function __construct($db, $id, $nome="", $password="", $percorso="", $descrizione="", $immagine="", $categoria=0, $posizione=0, $numeroDownload=0, $dataCreazione="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome           = $nome;
            $this->password       = $password;
            $this->percorso       = $percorso;
            $this->descrizione    = $descrizione;
            $this->immagine       = $immagine;
            $this->categoria      = $categoria;
            $this->posizione      = $posizione;
            $this->numeroDownload = $numeroDownload;
            $this->dataCreazione  = $dataCreazione;
        }

        public function crea() {
            $data     = date("Y-m-d");
            $query    = "INSERT INTO `geecB_risorse` (`id`, `nome`, `password`, `percorso`, `descrizione`, `immagine`, `categoria`, `posizione`, `numeroDownload`, `dataCreazione`) 
                            VALUES (NULL, '$this->nome', '$this->password', '$this->percorso', '$this->descrizione', '$this->immagine', '$this->categoria', '$this->posizione', '$this->numeroDownload', '$data')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        public function modifica() {
            $query    = "UPDATE `geecB_risorse` SET nome='$this->nome', password='$this->password', percorso='$this->percorso', descrizione='$this->descrizione', immagine='$this->immagine', categoria='$this->categoria', posizione='$this->posizione' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function elimina() {
            $this->db->eseguiQueryCancellazione("geecB_risorse",$this->id);
        }
        
        public function modificaImmagine($percorso) {
            $query    = "UPDATE `geecB_risorse` SET immagine='$percorso' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function aggiornaPercorsoFile($percorso) {
            $query    = "UPDATE `geecB_risorse` SET percorso='$percorso' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function caricaDatiDalDatabase() {
            $datiRisorsa  = $this->db->leggiSingolaRiga("geecB_risorse",$this->id);
            if($datiRisorsa) { // se esiste l'occorrenza nel database
                $this->nome        = $datiRisorsa["nome"];
                $this->password    = $datiRisorsa["password"];
                $this->percorso    = $datiRisorsa["percorso"];
                $this->descrizione = $datiRisorsa["descrizione"];
                $this->immagine    = $datiRisorsa["immagine"];
                $this->categoria   = $datiRisorsa["categoria"];
                $this->posizione      = $datiRisorsa["posizione"];
                $this->numeroDownload = $datiRisorsa["numeroDownload"];
                $this->dataCreazione  = $datiRisorsa["dataCreazione"];
            }
        }
        
        public function duplica($prefisso = "Copia di ") {
            $data     = date("Y-m-d");
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geecB_risorse WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geecB_risorse SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            // aggiorno il nome
            $query = "UPDATE geecB_risorse SET nome=CONCAT('$prefisso',' ',nome), numeroDownload=0 WHERE id=$idContenutoDuplicato";
            $this->db->eseguiQueryScrittura($query);
            return $idContenutoDuplicato;
        }
        
        function aggiungiAGruppo($idGruppo) {
            $query = "INSERT INTO `geecB_gruppiDestinatari` VALUES (NULL, 0, '$this->id', '$idGruppo')";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getPassword() {
            return $this->password;
        }

        public function getPercorso() {
            return $this->percorso;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getImmagine() {
            return $this->immagine;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getAccessibilita() {
            return $this->accessibilita;
        }

        public function getPosizione() {
            return $this->posizione;
        }

        public function getNumeroDownload() {
            return $this->numeroDownload;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }
        
        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setPassword($password) {
            $this->password = $password;
        }

        public function setPercorso($percorso) {
            $this->percorso = $percorso;
        }

        public function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        public function setImmagine($immagine) {
            $this->immagine = $immagine;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        public function setAccessibilita($accessibilita) {
            $this->accessibilita = $accessibilita;
        }
        
        public function setPosizione($posizione) {
            $this->posizione = $posizione;
        }

        public function setNumeroDownload($numeroDownload) {
            $this->numeroDownload = $numeroDownload;
        }

        public function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }
    }